/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.api;

import filenet.vw.api.VWException;
import filenet.vw.api.VWXMLHandler;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;

public final class VWWorkflowRuntimeId
implements Serializable {
    private static final long serialVersionUID = 7443L;
    private String m_serviceName = null;
    private String m_id = null;
    private Date m_timeStamp = null;
    private int m_region = -1;
    private int m_wcId = -1;
    private int m_wcRevision = -1;
    private int m_wsId = -1;
    private int m_WSDLVersion = 0;
    public static final String DATE_FORMAT = "MM/dd/yyyy hh:mm:ss";

    public static String _get_FILE_DATE() {
        return "$Date: 2010-02-23 21:59:12 GMT $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author: Kevin Bentley;096657649;kbentley@us.ibm.com (kbentley) $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision: /main/PUI_460_Int/1 $";
    }

    protected VWWorkflowRuntimeId(String serviceName, int region, Date regionTimeStamp, int workClassId, int workClassRevision, String id) {
        this.m_serviceName = serviceName;
        this.m_region = region;
        this.m_timeStamp = regionTimeStamp;
        this.m_wcId = workClassId;
        this.m_wcRevision = workClassRevision;
        this.m_id = id;
    }

    protected VWWorkflowRuntimeId(String serviceName, int region, Date regionTimeStamp, int workClassId, int workClassRevision, String id, int wsId) {
        this.m_serviceName = serviceName;
        this.m_region = region;
        this.m_timeStamp = regionTimeStamp;
        this.m_wcId = workClassId;
        this.m_wcRevision = workClassRevision;
        this.m_id = id;
        this.m_wsId = wsId;
    }

    protected VWWorkflowRuntimeId(String serviceName, int region, Date regionTimeStamp, int workClassId, int workClassRevision, String id, int wsId, int wsdlVersion) {
        this.m_serviceName = serviceName;
        this.m_region = region;
        this.m_timeStamp = regionTimeStamp;
        this.m_wcId = workClassId;
        this.m_wcRevision = workClassRevision;
        this.m_id = id;
        this.m_wsId = wsId;
        this.m_WSDLVersion = wsdlVersion;
    }

    public String getServiceName() {
        return this.m_serviceName;
    }

    public int getIsolatedRegion() {
        return this.m_region;
    }

    public Date getRegionTimeStamp() {
        return this.m_timeStamp;
    }

    public int getWorkClassId() {
        return this.m_wcId;
    }

    public int getWorkSpaceId() {
        return this.m_wsId;
    }

    public int getWorkClassRevision() {
        return this.m_wcRevision;
    }

    public String toString() {
        return this.m_id;
    }

    public int getWSDLVersion() {
        return this.m_WSDLVersion;
    }

    public void toXML(StringBuffer theBuffer) throws VWException {
        String ATTRIB_INDENT = "\t\t";
        SimpleDateFormat dateFormatter = new SimpleDateFormat(DATE_FORMAT);
        if (theBuffer == null) {
            throw new VWException("vw.api.VWWorkflowRuntimeIdNullBuffer", "buffer parameter cannot be null.");
        }
        theBuffer.append("\t<WFRuntimeId\n");
        theBuffer.append(ATTRIB_INDENT + "ServiceName=\"" + VWXMLHandler.toXMLString(this.m_serviceName) + "\"\n");
        theBuffer.append(ATTRIB_INDENT + "IsolatedRegion=\"" + this.m_region + "\"\n");
        String timeStamp = this.m_timeStamp != null ? dateFormatter.format(this.m_timeStamp) : null;
        theBuffer.append(ATTRIB_INDENT + "IRTimeStamp=\"" + VWXMLHandler.toXMLString(timeStamp) + "\"\n");
        theBuffer.append(ATTRIB_INDENT + "WorkClassId=\"" + this.m_wcId + "\"\n");
        theBuffer.append(ATTRIB_INDENT + "WCRevision=\"" + this.m_wcRevision + "\"\n");
        theBuffer.append(ATTRIB_INDENT + "Id=\"" + VWXMLHandler.toXMLString(this.m_id) + "\"\n");
        theBuffer.append(ATTRIB_INDENT + "WorkSpaceId=\"" + this.m_wsId + "\"\n");
        theBuffer.append(ATTRIB_INDENT + "WSDLVersion=\"" + this.m_WSDLVersion + "\"/>\n");
    }
}

